﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Reflection;
using System.Web.Script.Serialization;
using System.Collections.Specialized;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;


namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class AHOBPRQueueManager : AHOBPRBaseBO
    {
        private AHOBPRShared _sharedManager = new AHOBPRShared();
        private AHOBPRJsonDataManager _jsonManager = new AHOBPRJsonDataManager();
        private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();

        /// <summary>
        /// Get a list of queue items by queue batch ID
        /// </summary>
        /// <param name="queuebatchid"></param>
        /// <returns></returns>
        private List<QUEUE_LITE> GetQueue(string queuebatchid)
        {
            List<QUEUE_LITE> queue = new List<QUEUE_LITE>();
            try
            {
                Dictionary<String, Object> param = new Dictionary<string, object>();
                param.Add("@queueBatchId", Convert.ToInt32(queuebatchid));
                List<Object[]> rows = DbUtil.ExecuteSProc("AHOBPR.SP_ProcessQueueBatch", param);
                if (rows.Count == 0)
                {
                    return queue;
                }
                foreach(object[] rowItem in rows)
                {
                    QUEUE_LITE queueItem = new QUEUE_LITE()
                    {
                        QUEUE_ID = long.Parse(rowItem[0].ToString()),
                        REGISTRANT_ID = string.IsNullOrEmpty(rowItem[1].ToString()) ? 0 : int.Parse(rowItem[1].ToString()),
                        USER_ID = string.IsNullOrEmpty(rowItem[2].ToString()) ? 0 : int.Parse(rowItem[2].ToString()),
                        QUEUE_TYPE = rowItem[3].ToString(),
                        ITEM_ID = int.Parse(rowItem[4].ToString()),
                        ITEM_DESCRIPTION = rowItem[5].ToString(),
                        CREATEDBY = rowItem[6].ToString()
                    };
                    queue.Add(queueItem);

                }
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
            }
            return queue;
        }

        /// <summary>
        /// Save queue status
        /// </summary>
        /// <param name="queueFollowupStatus"></param>
        public void SaveQueueStatus(QUEUE_STATUS queueStatus)
        {
            try
            {
                Dictionary<String, Object> param = new Dictionary<string, object>();
                param.Add("@queueId", queueStatus.QUEUE_ID);
                param.Add("@registrantId", queueStatus.REGISTRANT_ID);
                param.Add("@processStartDate", queueStatus.PROCESS_START_DATE);
                param.Add("@processCompleteDate", queueStatus.PROCESS_COMPLETE_DATE);
                param.Add("@processStatus", queueStatus.PROCESS_STATUS == null ? " " : queueStatus.PROCESS_STATUS);
                param.Add("@processError", queueStatus.PROCESS_ERROR == null ? " " : queueStatus.PROCESS_ERROR);
                param.Add("@createdBy", "RESTful Service");
                param.Add("@processDescription", queueStatus.PROCESS_DESCRIPTION);
                param.Add("@userId", queueStatus.USER_ID);
                DbUtil.ExecuteSProc("AHOBPR.SP_InsertQueueStatus", param);
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "; " + ex.StackTrace);
            }
        }


        /// <summary>
        /// Process one queue batch 
        /// </summary>
        /// <param name="queuebatchid"></param>
        /// <returns></returns>
        public bool ProcessQueueBatch(string queuebatchid)
        {
            QUEUE_STATUS queueStatus = new QUEUE_STATUS();
            AHOBPRJsonDataManager jsonManager = new AHOBPRJsonDataManager();
            try
            {
                List<QUEUE_LITE> queue = GetQueue(queuebatchid);
                AHOBPREmailService emailServiceManager = new AHOBPREmailService();
                int sendMessageType;
                StringCollection emailList = new StringCollection();
                foreach (QUEUE_LITE queueItem in queue)
                {
                    queueStatus = new QUEUE_STATUS();
                    queueStatus.QUEUE_ID = queueItem.QUEUE_ID;
                    queueStatus.REGISTRANT_ID = queueItem.REGISTRANT_ID == 0 ? null : queueItem.REGISTRANT_ID;
                    queueStatus.USER_ID = queueItem.USER_ID == 0 ? null : queueItem.USER_ID;
                    queueStatus.PROCESS_START_DATE = DateTime.Now;
                    queueStatus.PROCESS_STATUS = "completed";
                    queueStatus.CREATEDBY = queueItem.CREATEDBY;
                    queueStatus.UPDATEDBY = queueItem.CREATEDBY;

                    switch (queueItem.QUEUE_TYPE)
                    {
                        case AHOBPRGlobal.AhobprQueueTypeUserEmail:
                            AHOBPRUserManager userManager = new AHOBPRUserManager();
                            DBO_USER userObject = userManager.GetDboUser((int)queueItem.USER_ID);
                            if (userObject == null)
                            {
                                queueStatus.PROCESS_ERROR = "User not found.";
                                queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                                SaveQueueStatus(queueStatus);
                            }
                            else
                            {
                                if (string.IsNullOrEmpty(userObject.EMAIL_ADDRESS))
                                {
                                    queueStatus.PROCESS_ERROR = "Email address not found for the user.";
                                    queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                                    SaveQueueStatus(queueStatus);
                                }
                                else
                                {
                                    string fullName = userObject.FIRST_NAME + " " + userObject.LAST_NAME;
                                    emailServiceManager.SendEmailToUser(userObject.USER_ID, fullName, queueItem.ITEM_ID, userObject.EMAIL_ADDRESS, queueItem.CREATEDBY);
                                    queueStatus.PROCESS_ERROR = string.Empty;
                                    queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                                    SaveQueueStatus(queueStatus);
                                }
                            }
                            break;
                        case AHOBPRGlobal.AhobprQueueTypeEmail:
                            sendMessageType = emailServiceManager.GetMessageType(queueItem.ITEM_ID);
                            emailList = emailServiceManager.GetEmailListForRegistrant((int)queueItem.REGISTRANT_ID);

                            if (emailList.Count > 0)
                            {
                                emailServiceManager.SendEmailToRegistrant((int)queueItem.REGISTRANT_ID, queueItem.ITEM_ID, emailList, sendMessageType, queueItem.CREATEDBY);
                                queueStatus.PROCESS_ERROR = string.Empty;
                            }
                            else
                            {
                                queueStatus.PROCESS_ERROR = "Email address not found for the registrant.";
                            }
                            queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                            SaveQueueStatus(queueStatus);
                            break;
                        case AHOBPRGlobal.AhobprQueueTypeNotification:
                            _jsonManager.CreateMessageJson(queueItem.REGISTRANT_ID.ToString(), queueItem.ITEM_ID.ToString(), queueItem.CREATEDBY);
                            queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                            SaveQueueStatus(queueStatus);
                           break;
                        case AHOBPRGlobal.AhobprQueueTypeFollowupQuestions:
                           bool exists = false;
                           _registrantManager.AddFollowupQuestionsToOneReigstrant((int)queueItem.REGISTRANT_ID, queueItem.ITEM_ID, ref exists);
                           if (exists == false)
                           {
                               // create user form json
                               _jsonManager.CreateUserFormJson(queueItem.REGISTRANT_ID.ToString(), queueItem.ITEM_ID.ToString(), queueItem.CREATEDBY);
                               queueStatus.PROCESS_ERROR = string.Empty;
                               queueStatus.PROCESS_DESCRIPTION = "User form JSON created for follow-up questionnaire.";
                               queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                               SaveQueueStatus(queueStatus);

                               // add an admin flag
                               string adminFlagName = queueItem.ITEM_DESCRIPTION.Substring(queueItem.ITEM_DESCRIPTION.IndexOf("AdminFlagName:", StringComparison.Ordinal) + 15).Trim();
                               _registrantManager.AddFlagToRegistrantByFlagName((int)queueItem.REGISTRANT_ID, adminFlagName, queueItem.CREATEDBY);
                               queueStatus.PROCESS_ERROR = string.Empty;
                               queueStatus.PROCESS_DESCRIPTION = "Admin flag added for follow-up questionnaire.";
                               queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                               SaveQueueStatus(queueStatus);

                               // send email
                               string emailTemplateId = queueItem.ITEM_DESCRIPTION.Substring(17, queueItem.ITEM_DESCRIPTION.IndexOf(",", StringComparison.Ordinal) - queueItem.ITEM_DESCRIPTION.IndexOf(":", StringComparison.Ordinal) - 2).Trim();
                               if (string.IsNullOrEmpty(emailTemplateId) == false)
                               {
                                   sendMessageType = emailServiceManager.GetMessageType(Convert.ToInt32(emailTemplateId));
                                   emailList = emailServiceManager.GetEmailListForRegistrant((int)queueItem.REGISTRANT_ID);

                                   if (emailList.Count > 0)
                                   {
                                       emailServiceManager.SendEmailToRegistrant((int)queueItem.REGISTRANT_ID, Convert.ToInt32(emailTemplateId), emailList, sendMessageType, queueItem.CREATEDBY);
                                       queueStatus.PROCESS_ERROR = string.Empty;
                                   }
                                   else
                                   {
                                       queueStatus.PROCESS_ERROR = "Email address not found for the registrant.";
                                   }
                                   queueStatus.PROCESS_DESCRIPTION = "Message sent for follow-up questionnaire.";
                                   queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                                   SaveQueueStatus(queueStatus);
                               }

                               // send notification
                               _jsonManager.CreateMessageJson(queueItem.REGISTRANT_ID.ToString(), emailTemplateId, queueItem.CREATEDBY);
                               queueStatus.PROCESS_ERROR = string.Empty;
                               queueStatus.PROCESS_DESCRIPTION = "Notification sent for follow-up questionnaire.";
                               queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                               SaveQueueStatus(queueStatus);
                           }
                            break;
                        case AHOBPRGlobal.AhobprQueueTypeFlag:
                            if (queueItem.ITEM_ID > 0)
                            {
                                if (_registrantManager.HasSubpopulationFlag((int) queueItem.REGISTRANT_ID, queueItem.ITEM_ID) == false)
                                {
                                    _registrantManager.AddFlagToRegistrantByFlagId((int)queueItem.REGISTRANT_ID, queueItem.ITEM_ID, queueItem.CREATEDBY);
                                }
                            }
                            else
                            {
                                _registrantManager.AddFlagToRegistrantByFlagName((int) queueItem.REGISTRANT_ID, queueItem.ITEM_DESCRIPTION, queueItem.CREATEDBY);
                            }
                            queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                            SaveQueueStatus(queueStatus);
                            break;
                    }
                }
                return true;
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Process Queue Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);

                queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                queueStatus.PROCESS_STATUS = "failed";
                queueStatus.PROCESS_ERROR = ex.Message;
                SaveQueueStatus(queueStatus);

                return false;
            }
        }

    }
}
